import pandas as pd   
import matplotlib.pyplot as plt  

   
# Load the dataset   
credit_customers = pd.read_csv("credit_customers.csv") 
  
# Plot histograms   
fig, axes = plt.subplots(2, 2, figsize=(12, 8))   

credit_customers['credit_history'].value_counts().plot(kind='bar', ax=axes[0, 0], title='Credit History')   
credit_customers['employment'].value_counts().plot(kind='bar', ax=axes[0, 1], title='Employment')   
credit_customers['age'].plot(kind='hist', bins=20, ax=axes[1, 0], title='Age')   
credit_customers['credit_amount'].plot(kind='hist', bins=20, ax=axes[1, 1], title='Credit Amount')   

plt.tight_layout()   
plt.savefig('ref_result/subplots.png')
plt.show() 

  